﻿Imports System.Windows.Media.Imaging
Imports Microsoft.Phone.Tasks

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private camera As New CameraCaptureTask()


    Public Sub New()
        InitializeComponent()

        AddHandler camera.Completed, AddressOf OnCameraCaptureTaskCompleted
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        camera.Show()

        args.Complete()
        args.Handled = True
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub OnCameraCaptureTaskCompleted(ByVal sender As Object, ByVal args As PhotoResult)
        If args.TaskResult = TaskResult.OK Then
            Dim bmp As New BitmapImage()
            bmp.SetSource(args.ChosenPhoto)
            img.Source = bmp
        End If
    End Sub
End Class
